<?php

namespace App\Http\Controllers;

use App\Models\Election;
use App\Models\User;
use Illuminate\Http\Request;

class JuryController extends Controller
{
    public function dashboard(Request $request)
    {
        $juryUserId = $request->session()->get('jury_user_id');
        if (! $juryUserId) {
            return redirect()->route('jury.login.form');
        }

        $jury = User::query()->where('id', $juryUserId)->where('role', 'jury')->where('is_active', true)->first();
        if (! $jury) {
            return redirect()->route('jury.login.form');
        }

        $election = Election::query()->latest('id')->first();
        if (! $election) {
            return view('jury.dashboard', [
                'election' => null,
                'personeroResults' => collect(),
                'contralorResults' => collect(),
                'personeroBlank' => 0,
                'contralorBlank' => 0,
                'totalBallots' => 0,
                'eligibleVoters' => 0,
                'turnoutPercent' => 0,
                'revealWinners' => false,
                'personeroWinner' => null,
                'contralorWinner' => null,
            ]);
        }

        return view('jury.dashboard', AdminController::buildScrutinyData($election));
    }
}
