<?php

namespace App\Http\Controllers;

use Illuminate\Http\Response;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;

class MediaController extends Controller
{
    public function showPublic(string $path)
    {
        $decodedPath = rawurldecode($path);

        if (Storage::disk('public')->exists($decodedPath)) {
            return response()->file(Storage::disk('public')->path($decodedPath));
        }

        $publicDirectPath = public_path($decodedPath);
        if (File::exists($publicDirectPath)) {
            return response()->file($publicDirectPath);
        }

        abort(404, 'Archivo no encontrado.');
    }
}
