<?php

namespace Database\Seeders;

use App\Models\Candidate;
use App\Models\Election;
use App\Models\Grade;
use App\Models\InstitutionSetting;
use App\Models\Student;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class InitialElectionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        InstitutionSetting::query()->firstOrCreate(
            ['id' => 1],
            [
                'school_name' => 'SISVOT Colegio',
                'election_year' => (string) now()->year,
                'configured_once' => false,
            ]
        );

        for ($level = 1; $level <= 11; $level++) {
            Grade::query()->updateOrCreate(
                ['level' => $level],
                ['name' => $level === 1 ? 'Primero' : "Grado {$level}"]
            );
        }

        $election = Election::query()->updateOrCreate(
            ['name' => 'Elección Escolar 2026'],
            [
                'starts_at' => now(),
                'ends_at' => now()->addDays(7),
                'candidate_upload_starts_at' => now()->subDays(3),
                'candidate_upload_ends_at' => now()->addDays(2),
                'voting_started_at' => null,
                'is_active' => true,
            ]
        );

        $grade10 = Grade::query()->where('level', 10)->firstOrFail();
        $grade11 = Grade::query()->where('level', 11)->firstOrFail();

        Candidate::query()->updateOrCreate(
            ['election_id' => $election->id, 'role' => 'personero', 'display_number' => 1],
            ['grade_id' => $grade11->id, 'full_name' => 'Ana Torres', 'proposal' => 'Convivencia escolar']
        );
        Candidate::query()->updateOrCreate(
            ['election_id' => $election->id, 'role' => 'personero', 'display_number' => 2],
            ['grade_id' => $grade11->id, 'full_name' => 'Luis Mendoza', 'proposal' => 'Mejora académica']
        );
        Candidate::query()->updateOrCreate(
            ['election_id' => $election->id, 'role' => 'contralor', 'display_number' => 1],
            ['grade_id' => $grade10->id, 'full_name' => 'María Gómez', 'proposal' => 'Control de recursos']
        );
        Candidate::query()->updateOrCreate(
            ['election_id' => $election->id, 'role' => 'contralor', 'display_number' => 2],
            ['grade_id' => $grade10->id, 'full_name' => 'Carlos Ruiz', 'proposal' => 'Rendición de cuentas']
        );

        $students = [
            ['full_name' => 'Sofía Díaz', 'grade' => 1, 'login_code' => 'STU001', 'pin' => '1234'],
            ['full_name' => 'Mateo Pérez', 'grade' => 5, 'login_code' => 'STU005', 'pin' => '1234'],
            ['full_name' => 'Valentina Rojas', 'grade' => 8, 'login_code' => 'STU008', 'pin' => '1234'],
            ['full_name' => 'Daniel Castro', 'grade' => 11, 'login_code' => 'STU011', 'pin' => '1234'],
        ];

        foreach ($students as $item) {
            $grade = Grade::query()->where('level', $item['grade'])->firstOrFail();

            Student::query()->updateOrCreate(
                ['login_code' => $item['login_code']],
                [
                    'grade_id' => $grade->id,
                    'full_name' => $item['full_name'],
                    'login_pin_hash' => Hash::make($item['pin']),
                    'has_voted' => false,
                    'voted_at' => null,
                ]
            );
        }
    }
}
