<!doctype html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title>Acta de Escrutinio</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; color: #1a1a2e; background: #fffef5; }
        .nb-card { position: relative; background: #fffef5; border-radius: 4px; border: 1px solid rgba(0,0,0,.08); }
        .nb-card::before { content: ''; position: absolute; left: 0; top: 0; bottom: 0; width: 28px; background: #1e4230; }
        .nb-body { padding: 18px; padding-left: 40px; }
        .acta { position: relative; border: 4px double #8a7340; padding: 12px; }
        .acta::before { content: ''; position: absolute; inset: 8px; border: 1.5px solid rgba(138,115,64,.25); }
        .watermark { position: absolute; top: 40%; left: 28%; transform: rotate(-25deg); font-size: 54px; color: rgba(45,90,61,.05); font-weight: 800; letter-spacing: 2px; }
        .title { margin: 0 0 6px 0; text-transform: uppercase; letter-spacing: 3px; color: #2d5a3d; text-align: center; }
        .divider { height: 2px; border: 0; background: linear-gradient(90deg, transparent, #c9a84c, transparent); margin: 10px 0; }
        .summary { width: 100%; border-collapse: collapse; }
        .summary td { border: 0; padding: 2px 0; }
        table { width: 100%; border-collapse: collapse; margin-top: 8px; }
        th, td { border: 1px solid #d7d7c2; padding: 6px; text-align: left; }
        th { background: #2d5a3d; color: #fff; }
        .winner-row td { background: #eaf7ef; border-color: #52b788; }
        .winner-cards { width: 100%; margin-top: 10px; }
        .winner-box { display: inline-block; width: 48%; margin-right: 2%; padding: 8px; color: #fff; background: linear-gradient(180deg, #2d5a3d, #1e4230); border-radius: 6px; }
        .stats { margin-top: 12px; border: 1px dashed #d8d8c8; background: #f5f5e8; padding: 8px; }
        .stats-col { display: inline-block; width: 32%; vertical-align: top; }
        .sign-grid { margin-top: 16px; border-top: 1.5px solid #8a7340; padding-top: 10px; }
        .sign-col { display: inline-block; width: 32%; text-align: center; font-size: 11px; }
        .section { margin-top: 12px; }
    </style>
</head>
<body>
    <div class="nb-card">
        <div class="nb-body">
            <div class="acta">
                <div class="watermark">OFICIAL</div>
                <h1 class="title">Acta Oficial de Escrutinio</h1>
                <hr class="divider">
                <table class="summary">
                    <tr><td><strong>Elección:</strong> {{ $election->name }}</td></tr>
                    <tr><td><strong>Estado:</strong> {{ $election->is_active ? 'Activa' : 'Cerrada' }}</td></tr>
                    <tr><td><strong>Fecha generación:</strong> {{ now() }}</td></tr>
                </table>

                @if($revealWinners)
                <div class="winner-cards">
                    <div class="winner-box"><strong>Personero:</strong> {{ $personeroWinner?->full_name ?? 'N/A' }}</div>
                    <div class="winner-box"><strong>Contralor:</strong> {{ $contralorWinner?->full_name ?? 'N/A' }}</div>
                </div>
                @endif

                <div class="stats">
                    <div class="stats-col"><strong>Tarjetones:</strong> {{ $totalBallots }}</div>
                    <div class="stats-col"><strong>Habilitados:</strong> {{ $eligibleVoters }}</div>
                    <div class="stats-col"><strong>Participación:</strong> {{ $turnoutPercent }}%</div>
                </div>

                <div class="section">
                    <h2>Resultados Personero</h2>
                    <table>
                        <thead>
                            <tr><th>Candidato</th><th>Votos</th><th>%</th></tr>
                        </thead>
                        <tbody>
                            @foreach($personeroResults as $row)
                                <tr class="{{ $personeroWinner && $personeroWinner->id === $row->id ? 'winner-row' : '' }}">
                                    <td>#{{ $row->display_number }} - {{ $row->full_name }}</td>
                                    <td>{{ $row->votes_count }}</td>
                                    <td>{{ $row->percent }}%</td>
                                </tr>
                            @endforeach
                            <tr><td><strong>Voto en blanco</strong></td><td><strong>{{ $personeroBlank }}</strong></td><td></td></tr>
                        </tbody>
                    </table>
                </div>

                <div class="section">
                    <h2>Resultados Contralor</h2>
                    <table>
                        <thead>
                            <tr><th>Candidato</th><th>Votos</th><th>%</th></tr>
                        </thead>
                        <tbody>
                            @foreach($contralorResults as $row)
                                <tr class="{{ $contralorWinner && $contralorWinner->id === $row->id ? 'winner-row' : '' }}">
                                    <td>#{{ $row->display_number }} - {{ $row->full_name }}</td>
                                    <td>{{ $row->votes_count }}</td>
                                    <td>{{ $row->percent }}%</td>
                                </tr>
                            @endforeach
                            <tr><td><strong>Voto en blanco</strong></td><td><strong>{{ $contralorBlank }}</strong></td><td></td></tr>
                        </tbody>
                    </table>
                </div>

                <div class="sign-grid">
                    <div class="sign-col">________________________<br>Jurado 1</div>
                    <div class="sign-col">________________________<br>Jurado 2</div>
                    <div class="sign-col">________________________<br>Presidencia Electoral</div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
