@extends('layouts.app')

@section('content')
<div class="max-w-xl mx-auto nb-card">
    <div class="nb-spiral" id="sp-login-admin" data-spiral-count="10"></div>
    <div class="nb-body">
    <h1 class="text-3xl font-bold text-slate-900">Acceso Administración</h1>
    <p class="mt-2 hand text-slate-700">Panel de configuración, cierre y escrutinio electoral.</p>

    <form method="POST" action="{{ route('admin.login.submit') }}" class="mt-6 space-y-5">
        @csrf
        <div>
            <label class="block text-sm font-semibold text-slate-700 mb-2">Correo administrador</label>
            <input class="w-full rounded-xl border border-slate-300 px-4 py-3 text-base focus:ring-2 focus:ring-blue-500 focus:border-blue-500" type="email" name="email" value="{{ old('email') }}" required>
            @error('email') <div class="mt-2 text-sm text-red-600">{{ $message }}</div> @enderror
        </div>
        <div>
            <label class="block text-sm font-semibold text-slate-700 mb-2">Contraseña</label>
            <input class="w-full rounded-xl border border-slate-300 px-4 py-3 text-base focus:ring-2 focus:ring-blue-500 focus:border-blue-500" type="password" name="password" required>
            @error('password') <div class="mt-2 text-sm text-red-600">{{ $message }}</div> @enderror
        </div>

        <button class="w-full h-16 rounded-2xl bg-blue-600 text-white text-lg font-semibold hover:bg-blue-700 transition" type="submit">Entrar</button>
    </form>

    <div class="mt-5 flex flex-col sm:flex-row gap-3">
        <a class="inline-flex w-full sm:w-auto items-center justify-center h-14 px-6 rounded-2xl bg-slate-700 text-white font-semibold hover:bg-slate-800 transition" href="{{ route('login.form') }}">Volver a inicio</a>
        <a class="inline-flex w-full sm:w-auto items-center justify-center h-14 px-6 rounded-2xl bg-slate-200 text-slate-800 font-semibold hover:bg-slate-300 transition" href="{{ route('jury.login.form') }}">Ir a jurado</a>
    </div>

    <div class="mt-4 text-sm text-slate-600">
        ¿Primera vez? <a class="text-blue-600 font-semibold" href="{{ route('setup.initial.form') }}">Crear administrador inicial</a>
    </div>
    </div>
</div>
@endsection
