@extends('layouts.app')

@section('content')
<div class="max-w-xl mx-auto nb-card">
    <div class="nb-spiral" id="sp-login-student" data-spiral-count="10"></div>
    <div class="nb-body">
    <h1 class="text-3xl font-bold text-slate-900">SISVOT</h1>
    <p class="mt-2 hand text-slate-700">Ingreso de votantes. Cada estudiante puede votar una sola vez.</p>

    <form method="POST" action="{{ route('login.submit') }}" class="mt-6 space-y-5">
        @csrf
        <div>
            <label class="block text-sm font-semibold text-slate-700 mb-2">Código de estudiante</label>
            <input class="w-full rounded-xl border border-slate-300 px-4 py-3 text-base focus:ring-2 focus:ring-blue-500 focus:border-blue-500" type="text" name="login_code" value="{{ old('login_code') }}" required>
            @error('login_code') <div class="mt-2 text-sm text-red-600">{{ $message }}</div> @enderror
        </div>

        <div>
            <label class="block text-sm font-semibold text-slate-700 mb-2">PIN</label>
            <input class="w-full rounded-xl border border-slate-300 px-4 py-3 text-base focus:ring-2 focus:ring-blue-500 focus:border-blue-500" type="password" name="pin" required>
            @error('pin') <div class="mt-2 text-sm text-red-600">{{ $message }}</div> @enderror
        </div>

        <button class="w-full h-16 rounded-2xl bg-blue-600 text-white text-lg font-semibold hover:bg-blue-700 transition" type="submit">Ingresar a votar</button>
    </form>
    </div>
</div>
@endsection
