@extends('layouts.app')

@section('content')
<div class="nb-card">
    <div class="nb-spiral" id="sp-ballot-main" data-spiral-count="10"></div>
    <div class="nb-body">
    <h1 class="text-2xl md:text-3xl font-bold text-slate-900">{{ $election->name }}</h1>
    <p class="mt-2 hand text-slate-700">Estudiante: <span class="font-semibold text-slate-800">{{ $student->full_name }}</span> · {{ $student->grade->name }}</p>
    <p class="mt-1 text-slate-600"><span class="inline-flex items-center rounded-full px-3 py-1" style="background:var(--yellow); box-shadow:0 3px 0 rgba(0,0,0,.2); font-family:'Fredoka',cursive;">🔒 Voto Secreto</span></p>

    @if($errors->has('general'))
        <div class="mt-4 al-err">{{ $errors->first('general') }}</div>
    @endif

    <form method="POST" action="{{ route('voting.submit') }}" class="mt-6 space-y-6">
        @csrf

        <div class="rounded-2xl border border-slate-200 bg-slate-50 p-4 md:p-6">
            <h3 class="text-xl font-bold mb-4" style="background:var(--blue);color:#fff;padding:.7rem 1rem;border-radius:10px;text-shadow:2px 2px 0 rgba(0,0,0,.2);">Personero</h3>
            <div class="grid vote-grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
                @foreach($personeros as $candidate)
                    <label class="vote-option candidate-card cursor-pointer p-3 shadow-sm hover:shadow-md transition">
                        <div class="candidate-top"></div>
                        <input class="vote-radio mb-3 h-4 w-4" type="radio" name="personero_choice" value="{{ $candidate->id }}" required>
                        <span class="medal personero">{{ $candidate->display_number }}</span>
                        @php
                            $candidateIsImage = $candidate->photo_path && preg_match('/\.(jpg|jpeg|png|gif|webp|bmp|svg)$/i', $candidate->photo_path);
                        @endphp
                        @if($candidate->photo_url && $candidateIsImage)
                            <img class="w-full h-44 object-cover rounded-xl bg-slate-200" src="{{ $candidate->photo_url }}" alt="Foto {{ $candidate->full_name }}">
                        @elseif($candidate->photo_path)
                            <div class="w-full h-44 rounded-xl bg-slate-200 flex flex-col items-center justify-center text-slate-500 text-sm px-3 text-center">
                                <span class="text-2xl">📄</span>
                                <span class="mt-2 font-medium">Archivo no visualizable</span>
                            </div>
                        @else
                            <div class="w-full h-44 rounded-xl bg-slate-200 flex items-center justify-center text-slate-500 text-sm">Sin foto</div>
                        @endif
                        <span class="role-pill personero">Personero</span>
                        <p class="candidate-name mt-3 text-base text-slate-900">{{ $candidate->full_name }}</p>
                        <p class="candidate-grade mt-1 text-slate-700">📚 {{ $candidate->grade->name }}</p>
                        @if($candidate->proposal)
                            <p class="candidate-proposal mt-2">{{ $candidate->proposal }}</p>
                        @endif
                    </label>
                @endforeach
                <label class="vote-option candidate-card cursor-pointer p-3 shadow-sm hover:shadow-md transition">
                    <div class="candidate-top"></div>
                    <input class="vote-radio mb-3 h-4 w-4" type="radio" name="personero_choice" value="blanco" required>
                    <div class="w-full h-44 rounded-xl bg-slate-100 flex flex-col items-center justify-center text-slate-600 text-sm px-3 text-center">
                        <span class="text-2xl">🗳️</span>
                        <span class="mt-2 font-semibold">Voto en blanco</span>
                        <span class="mt-1 text-xs">Ningún candidato para personero</span>
                    </div>
                </label>
            </div>
            @error('personero_choice') <div class="mt-2 text-sm text-red-600">{{ $message }}</div> @enderror
        </div>

        <div class="rounded-2xl border border-slate-200 bg-slate-50 p-4 md:p-6">
            <h3 class="text-xl font-bold mb-4" style="background:var(--orange);color:#fff;padding:.7rem 1rem;border-radius:10px;text-shadow:2px 2px 0 rgba(0,0,0,.2);">Contralor</h3>
            <div class="grid vote-grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
                @foreach($contralores as $candidate)
                    <label class="vote-option candidate-card cursor-pointer p-3 shadow-sm hover:shadow-md transition">
                        <div class="candidate-top contralor"></div>
                        <input class="vote-radio mb-3 h-4 w-4" type="radio" name="contralor_choice" value="{{ $candidate->id }}" required>
                        <span class="medal contralor">{{ $candidate->display_number }}</span>
                        @php
                            $candidateIsImage = $candidate->photo_path && preg_match('/\.(jpg|jpeg|png|gif|webp|bmp|svg)$/i', $candidate->photo_path);
                        @endphp
                        @if($candidate->photo_url && $candidateIsImage)
                            <img class="w-full h-44 object-cover rounded-xl bg-slate-200" src="{{ $candidate->photo_url }}" alt="Foto {{ $candidate->full_name }}">
                        @elseif($candidate->photo_path)
                            <div class="w-full h-44 rounded-xl bg-slate-200 flex flex-col items-center justify-center text-slate-500 text-sm px-3 text-center">
                                <span class="text-2xl">📄</span>
                                <span class="mt-2 font-medium">Archivo no visualizable</span>
                            </div>
                        @else
                            <div class="w-full h-44 rounded-xl bg-slate-200 flex items-center justify-center text-slate-500 text-sm">Sin foto</div>
                        @endif
                        <span class="role-pill contralor">Contralor</span>
                        <p class="candidate-name mt-3 text-base text-slate-900">{{ $candidate->full_name }}</p>
                        <p class="candidate-grade mt-1 text-slate-700">📚 {{ $candidate->grade->name }}</p>
                        @if($candidate->proposal)
                            <p class="candidate-proposal mt-2">{{ $candidate->proposal }}</p>
                        @endif
                    </label>
                @endforeach
                <label class="vote-option candidate-card cursor-pointer p-3 shadow-sm hover:shadow-md transition">
                    <div class="candidate-top contralor"></div>
                    <input class="vote-radio mb-3 h-4 w-4" type="radio" name="contralor_choice" value="blanco" required>
                    <div class="w-full h-44 rounded-xl bg-slate-100 flex flex-col items-center justify-center text-slate-600 text-sm px-3 text-center">
                        <span class="text-2xl">🗳️</span>
                        <span class="mt-2 font-semibold">Voto en blanco</span>
                        <span class="mt-1 text-xs">Ningún candidato para contralor</span>
                    </div>
                </label>
            </div>
            @error('contralor_choice') <div class="mt-2 text-sm text-red-600">{{ $message }}</div> @enderror
        </div>

        <button class="w-full h-16 rounded-2xl bg-blue-600 text-white text-lg font-semibold hover:bg-blue-700 transition" type="submit">Enviar voto</button>
    </form>

    <form method="POST" action="{{ route('logout') }}" class="mt-4">
        @csrf
        <button class="w-full h-14 rounded-2xl bg-slate-700 text-white text-base font-semibold hover:bg-slate-800 transition" type="submit">Cerrar sesión</button>
    </form>
    </div>
</div>

<script>
    (function () {
        const radios = document.querySelectorAll('.vote-radio');

        function paintSelection(groupName) {
            document.querySelectorAll('input[name="' + groupName + '"]').forEach(function (radio) {
                const card = radio.closest('.vote-option');
                if (!card) return;

                if (radio.checked) {
                    card.classList.add('selected', 'shadow-md', 'bg-blue-50');
                    card.classList.remove('border-slate-200');
                    card.style.borderColor = radio.name === 'personero_choice' ? 'var(--blue)' : 'var(--orange)';
                } else {
                    card.classList.remove('selected', 'shadow-md', 'bg-blue-50');
                    card.classList.add('border-slate-200');
                    card.style.borderColor = '#ddd';
                }
            });
        }

        radios.forEach(function (radio) {
            radio.addEventListener('change', function () {
                paintSelection(radio.name);
            });
        });

        paintSelection('personero_choice');
        paintSelection('contralor_choice');
    })();
</script>
@endsection
