

<?php $__env->startSection('content'); ?>
<div class="max-w-2xl mx-auto nb-card nb-green">
    <div class="nb-spiral" id="sp-receipt" data-spiral-count="10"></div>
    <div class="nb-body">
    <h1 class="text-3xl font-bold text-slate-900">Certificado de Votación</h1>

    <?php if(session('status')): ?>
        <div class="mt-4 al-success"><?php echo e(session('status')); ?></div>
    <?php endif; ?>

    <div class="mt-5 space-y-2 text-slate-700">
        <p><strong>Elección:</strong> <?php echo e($receipt->election->name); ?></p>
        <p><strong>Fecha y hora:</strong> <?php echo e($receipt->voted_at); ?></p>
        <p><strong>Código de certificado:</strong> <span style="font-family:'Patrick Hand',cursive;background:#f5f5e8;border:2px dashed #d8d8c8;padding:.15rem .45rem;border-radius:8px;"><?php echo e($receipt->receipt_code); ?></span></p>
    </div>

    <div class="mt-5 al-success">
        Tu voto fue registrado. Este certificado confirma participación, pero no revela por quién votaste.
    </div>

    <a class="mt-5 inline-flex w-full items-center justify-center h-16 rounded-2xl bg-blue-600 text-white text-lg font-semibold hover:bg-blue-700 transition" href="<?php echo e(route('voting.receipt.pdf')); ?>">Descargar certificado PDF</a>

    <p class="mt-4 text-slate-700">Verificación pública:
        <a href="<?php echo e(route('voting.receipt.verify', $receipt->receipt_code)); ?>"><?php echo e(route('voting.receipt.verify', $receipt->receipt_code)); ?></a>
    </p>

    <form method="POST" action="<?php echo e(route('logout')); ?>" class="mt-5">
        <?php echo csrf_field(); ?>
        <button class="w-full h-14 rounded-2xl bg-slate-700 text-white text-base font-semibold hover:bg-slate-800 transition" type="submit">Salir</button>
    </form>
    </div>
</div>

<?php if(session('auto_download_receipt')): ?>
<script>
    window.setTimeout(function () {
        window.location.href = "<?php echo e(route('voting.receipt.pdf')); ?>";
    }, 800);
</script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Francisco\Documents\2026\APLICACIONES APPS\APPLICACIONES\SISVOT\resources\views\voting\receipt.blade.php ENDPATH**/ ?>