<!doctype html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e($title ?? 'SISVOT'); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Fredoka:wght@400;500;600;700&family=Nunito:wght@400;600;700;800;900&family=Patrick+Hand&display=swap" rel="stylesheet">
    <style>
        :root {
            --chalk: #f5f0e8;
            --board: #2d5a3d;
            --board2: #1e4230;
            --red: #e63946;
            --blue: #2176ae;
            --yellow: #f9c22e;
            --green: #52b788;
            --orange: #f4845f;
            --purple: #9b5de5;
            --pink: #f15bb5;
            --ink: #1a1a2e;
            --paper: #fffef5;
            --ruled: #d4e4f7;
            --margin: #ffb3ba;
            --bounce: cubic-bezier(.34, 1.5, .64, 1);
        }

        * { box-sizing: border-box; }

        body {
            margin: 0;
            min-height: 100vh;
            font-family: 'Nunito', sans-serif;
            background: var(--paper);
            color: var(--ink);
            position: relative;
        }

        body::before {
            content: '';
            position: fixed;
            inset: 0;
            pointer-events: none;
            z-index: -2;
            background: repeating-linear-gradient(
                180deg,
                transparent,
                transparent 31px,
                var(--ruled) 31px,
                var(--ruled) 32px
            );
        }

        body::after {
            content: '';
            position: fixed;
            top: 0;
            bottom: 0;
            left: 80px;
            width: 2px;
            background: var(--margin);
            opacity: .9;
            pointer-events: none;
            z-index: -1;
        }

        h1, h2, h3, h4, h5, .font-title {
            font-family: 'Fredoka', cursive;
            color: var(--ink);
        }

        .hand, label {
            font-family: 'Patrick Hand', cursive;
        }

        .app-header {
            background-color: var(--board);
            background-image:
                repeating-linear-gradient(0deg, transparent, transparent 3px, rgba(255,255,255,.015) 3px, rgba(255,255,255,.015) 4px),
                repeating-linear-gradient(90deg, transparent, transparent 3px, rgba(255,255,255,.015) 3px, rgba(255,255,255,.015) 4px);
            box-shadow: 0 4px 0 rgba(0,0,0,.2);
            color: white;
            position: sticky;
            top: 0;
            z-index: 200;
        }

        .app-logo {
            width: 52px;
            height: 52px;
            border-radius: 999px;
            background: var(--yellow);
            box-shadow: 0 3px 0 rgba(0,0,0,.25);
            display: grid;
            place-items: center;
            font-size: 1.3rem;
        }

        .app-title {
            font-family: 'Fredoka', cursive;
            text-shadow: 2px 2px 0 rgba(0,0,0,.25);
            color: #fff;
        }

        .nav-btn {
            border: 2px solid rgba(255,255,255,.2);
            background: transparent;
            color: #fff;
            border-radius: 10px;
            padding: .52rem .8rem;
            font-family: 'Fredoka', cursive;
            transition: .2s var(--bounce);
        }

        .nav-btn.active {
            background: var(--yellow);
            color: var(--ink);
            box-shadow: 0 4px 0 rgba(0,0,0,.2);
        }

        .status-pill {
            border: 2.5px solid currentColor;
            border-radius: 999px;
            padding: .2rem .65rem;
            font-size: .8rem;
            background: rgba(255,255,255,.15);
            font-family: 'Patrick Hand', cursive;
        }

        .nb-card {
            position: relative;
            background: var(--paper);
            border-radius: 4px 12px 12px 4px;
            box-shadow: 4px 4px 0 rgba(0,0,0,.12), 0 0 0 1px rgba(0,0,0,.06);
            overflow: hidden;
            animation: popIn .45s var(--bounce);
        }

        .nb-card::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            bottom: 0;
            width: 38px;
            background: var(--board2);
        }

        .nb-card.nb-green::before {
            background: var(--green);
        }

        .nb-spiral {
            position: absolute;
            left: 0;
            top: 10px;
            bottom: 10px;
            width: 38px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: space-between;
            z-index: 2;
        }

        .nb-dot {
            width: 16px;
            height: 16px;
            border-radius: 50%;
            background: var(--chalk);
            border: 2px solid rgba(0,0,0,.35);
            box-shadow: inset 0 2px 3px rgba(255,255,255,.7), inset 0 -2px 2px rgba(0,0,0,.18);
        }

        .nb-body {
            padding: 22px;
            padding-left: 54px;
        }

        .bg-white.rounded-2xl.shadow-lg.border.border-slate-200 {
            position: relative;
            background: var(--paper) !important;
            border-radius: 4px 12px 12px 4px !important;
            box-shadow: 4px 4px 0 rgba(0,0,0,.12), 0 0 0 1px rgba(0,0,0,.06) !important;
            overflow: hidden;
            padding-left: 54px !important;
        }

        .bg-white.rounded-2xl.shadow-lg.border.border-slate-200::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            bottom: 0;
            width: 38px;
            background: var(--board2);
        }

        .bg-white.rounded-2xl.shadow-lg.border.border-slate-200::after {
            content: '';
            position: absolute;
            left: 11px;
            top: 12px;
            bottom: 12px;
            width: 16px;
            background: radial-gradient(circle, var(--chalk) 0 6px, transparent 6px 100%);
            background-size: 16px 28px;
            background-repeat: repeat-y;
        }

        .sticker-grid { grid-template-columns: repeat(4, minmax(0, 1fr)); }

        .sticker {
            background: var(--paper);
            border-radius: 16px;
            box-shadow: 4px 4px 0 rgba(0,0,0,.12);
            position: relative;
            transition: transform .25s var(--bounce);
        }

        .sticker::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 6px;
            border-radius: 16px 16px 10px 10px;
            background: var(--top, var(--blue));
        }

        .sticker:hover { transform: translateY(-4px) rotate(-1deg); }

        .sticker-num {
            font-family: 'Fredoka', cursive;
            font-size: 2rem;
        }

        .sticker-label {
            font-family: 'Patrick Hand', cursive;
            color: #888;
            font-size: .95rem;
        }

        .grid.grid-cols-1.md\:grid-cols-2.xl\:grid-cols-4.gap-4 > div {
            background: var(--paper) !important;
            border-radius: 16px !important;
            box-shadow: 4px 4px 0 rgba(0,0,0,.12);
            position: relative;
            overflow: hidden;
            transition: transform .25s var(--bounce);
        }

        .grid.grid-cols-1.md\:grid-cols-2.xl\:grid-cols-4.gap-4 > div::before {
            content: '';
            position: absolute;
            left: 0;
            right: 0;
            top: 0;
            height: 6px;
            border-radius: 16px 16px 10px 10px;
        }

        .grid.grid-cols-1.md\:grid-cols-2.xl\:grid-cols-4.gap-4 > div:nth-child(1)::before { background: var(--red); }
        .grid.grid-cols-1.md\:grid-cols-2.xl\:grid-cols-4.gap-4 > div:nth-child(2)::before { background: var(--blue); }
        .grid.grid-cols-1.md\:grid-cols-2.xl\:grid-cols-4.gap-4 > div:nth-child(3)::before { background: var(--green); }
        .grid.grid-cols-1.md\:grid-cols-2.xl\:grid-cols-4.gap-4 > div:nth-child(4)::before { background: var(--purple); }

        .grid.grid-cols-1.md\:grid-cols-2.xl\:grid-cols-4.gap-4 > div:hover {
            transform: translateY(-4px) rotate(-1deg);
        }

        .candidate-card {
            position: relative;
            background: #fff;
            border-radius: 14px;
            border: 2.5px solid #ddd;
            box-shadow: 0 2px 0 rgba(0,0,0,.08);
            transition: .28s var(--bounce);
        }

        .candidate-card:hover {
            transform: translateY(-8px) rotate(.8deg);
            box-shadow: 0 8px 0 rgba(0,0,0,.12);
        }

        .candidate-top {
            height: 10px;
            border-radius: 12px 12px 0 0;
            background: repeating-linear-gradient(90deg, var(--blue), var(--blue) 7px, #184f79 7px, #184f79 14px);
        }

        .candidate-top.contralor {
            background: repeating-linear-gradient(90deg, var(--orange), var(--orange) 7px, #d26d48 7px, #d26d48 14px);
        }

        .medal {
            width: 52px;
            height: 52px;
            border-radius: 50%;
            display: grid;
            place-items: center;
            font-family: 'Fredoka', cursive;
            font-size: 1.1rem;
            color: white;
            box-shadow: 0 4px 0 rgba(0,0,0,.2), 0 0 0 4px #fff, 0 0 0 7px rgba(0,0,0,.18);
            position: absolute;
            top: 16px;
            right: 16px;
        }

        .medal::after {
            content: '★';
            position: absolute;
            bottom: -20px;
            color: var(--yellow);
            font-size: .95rem;
            text-shadow: 1px 1px 0 rgba(0,0,0,.2);
        }

        .medal.personero { background: radial-gradient(circle at 30% 25%, #5ea3d1, var(--blue)); }
        .medal.contralor { background: radial-gradient(circle at 30% 25%, #f7aa8f, var(--orange)); }

        .role-pill {
            display: inline-flex;
            border-radius: 999px;
            padding: .2rem .7rem;
            color: #fff;
            font-weight: 800;
            font-size: .76rem;
        }

        .role-pill.personero { background: var(--blue); }
        .role-pill.contralor { background: var(--orange); }

        .candidate-name { font-family: 'Fredoka', cursive; font-size: 1.1rem; }
        .candidate-grade { font-family: 'Patrick Hand', cursive; }
        .candidate-proposal {
            background: #f5f5e8;
            border-left: 3px solid var(--yellow);
            font-family: 'Patrick Hand', cursive;
            font-style: italic;
            padding: .5rem .65rem;
            border-radius: 0 10px 10px 0;
        }

        input[type="text"], input[type="email"], input[type="password"], input[type="number"], input[type="datetime-local"], select, textarea {
            border: 2.5px solid #ddd !important;
            border-radius: 10px !important;
            font-family: 'Nunito', sans-serif;
            color: var(--ink);
            outline: none;
        }

        input:focus, select:focus, textarea:focus {
            border-color: var(--blue) !important;
            box-shadow: 0 0 0 3px rgba(33,118,174,.12) !important;
        }

        button, .btn-like {
            font-family: 'Fredoka', cursive !important;
            border-radius: 10px !important;
            box-shadow: 0 4px 0 rgba(0,0,0,.2);
            transition: transform .15s ease, box-shadow .15s ease;
        }

        button:active, .btn-like:active {
            transform: translateY(3px);
            box-shadow: none;
        }

        .al-info, .al-success, .al-warn, .al-err {
            border: 2.5px solid;
            border-radius: 10px;
            font-family: 'Patrick Hand', cursive;
            font-size: 1rem;
            padding: .65rem .9rem;
        }
        .al-info { border-color: var(--blue); background: #e6f1f8; color: #1b597f; }
        .al-success { border-color: var(--green); background: #eaf7f0; color: #2e7f5b; }
        .al-warn { border-color: var(--yellow); background: #fff8dd; color: #7a6205; }
        .al-err { border-color: var(--red); background: #fdecef; color: #99222c; }

        .rounded-xl.border.border-amber-200.bg-amber-50,
        .rounded-xl.border.border-emerald-200.bg-emerald-50,
        .rounded-xl.border.border-red-200.bg-red-50 {
            border-width: 2.5px !important;
            border-radius: 10px !important;
            font-family: 'Patrick Hand', cursive;
            font-size: 1rem;
        }

        table {
            border-collapse: separate;
            border-spacing: 0 4px;
        }

        thead th {
            background: var(--board);
            color: #fff;
            font-family: 'Fredoka', cursive;
            border: none !important;
        }

        tbody td {
            background: #fff;
            border-top: 1px solid #e5e7eb;
            border-bottom: 1px solid #e5e7eb;
        }

        tbody td:first-child {
            border-left: 1px solid #e5e7eb;
            border-radius: 10px 0 0 10px;
        }

        tbody td:last-child {
            border-right: 1px solid #e5e7eb;
            border-radius: 0 10px 10px 0;
        }

        tbody tr:hover td {
            background: #fafaf0;
        }

        .login-board {
            min-height: 100vh;
            background-color: var(--board);
            background-image:
                repeating-linear-gradient(0deg, transparent, transparent 3px, rgba(255,255,255,.015) 3px, rgba(255,255,255,.015) 4px),
                repeating-linear-gradient(90deg, transparent, transparent 3px, rgba(255,255,255,.015) 3px, rgba(255,255,255,.015) 4px);
            position: relative;
            padding: 56px 16px 24px;
        }

        .login-board::after {
            content: '';
            position: absolute;
            inset: 18px;
            border: 6px solid rgba(255,255,255,.12);
            pointer-events: none;
        }

        .login-emojis span {
            position: absolute;
            opacity: .35;
            font-size: 2rem;
            transform: rotate(var(--rot));
            pointer-events: none;
        }

        .login-title {
            text-align: center;
            color: #fff;
            font-family: 'Fredoka', cursive;
            font-size: clamp(1.6rem, 3vw, 2.1rem);
            text-shadow: 3px 3px 0 rgba(0,0,0,.32);
            margin-bottom: 16px;
        }

        .login-menu {
            display: flex;
            justify-content: center;
            gap: .65rem;
            flex-wrap: wrap;
            margin: 0 auto 18px;
            max-width: 840px;
        }

        .login-menu .nav-btn {
            min-width: 170px;
            text-align: center;
            text-decoration: none;
        }

        .vote-option {
            position: relative;
            background: #fff;
            border: 2.5px solid #ddd !important;
            border-radius: 14px !important;
            box-shadow: 0 2px 0 rgba(0,0,0,.08) !important;
            transition: .25s var(--bounce);
        }

        .vote-option:hover {
            transform: translateY(-4px) rotate(-1deg);
            box-shadow: 0 6px 0 rgba(0,0,0,.12) !important;
        }

        .vote-option.selected {
            transform: translateY(-4px) rotate(-1deg);
        }

        .vote-option.selected::after {
            content: '✓';
            position: absolute;
            top: 10px;
            right: 10px;
            width: 28px;
            height: 28px;
            border-radius: 50%;
            background: #fff;
            display: grid;
            place-items: center;
            animation: checkPop .3s var(--bounce);
            font-family: 'Fredoka', cursive;
            font-weight: 700;
        }

        @keyframes popIn {
            from { transform: scale(.97) translateY(6px); opacity: .9; }
            to { transform: scale(1) translateY(0); opacity: 1; }
        }

        @keyframes pulse {
            from { transform: scale(1); opacity: 1; }
            to { transform: scale(.7); opacity: .4; }
        }

        @keyframes checkPop {
            from { transform: scale(0) rotate(-20deg); }
            to { transform: scale(1) rotate(0); }
        }

        @keyframes bigBounce {
            from { transform: scale(0) rotate(-20deg); }
            to { transform: scale(1) rotate(0); }
        }

        @keyframes modalPop {
            from { transform: scale(.85) translateY(20px); }
            to { transform: scale(1) translateY(0); }
        }

        @media (max-width: 767px) {
            body::after { display: none; }
            .sticker-grid { grid-template-columns: repeat(2, minmax(0, 1fr)); }
            .vote-grid { grid-template-columns: repeat(2, minmax(0, 1fr)) !important; }
        }

        @media print {
            header, button, .no-print, a.btn-like { display: none !important; }
            .nb-card, .nb-body { box-shadow: none !important; }
        }
    </style>
</head>
<body>
<?php
    $institution = \App\Models\InstitutionSetting::query()->first();
    $institutionName = $institution?->school_name ?? 'SISVOT Colegio';
    $institutionYear = $institution?->election_year ?? now()->year;
    $institutionLogo = $institution?->logo_url;
    $isLoginScreen = request()->routeIs('login.form') || request()->routeIs('admin.login.form') || request()->routeIs('jury.login.form') || request()->routeIs('setup.initial.form');
?>

<?php if($isLoginScreen): ?>
    <main class="login-board">
        <div class="login-emojis" aria-hidden="true">
            <span style="top: 28px; left: 38px; --rot: -9deg;">✏️ ★</span>
            <span style="top: 34px; right: 42px; --rot: 8deg;">📚 🎓</span>
            <span style="bottom: 40px; left: 45px; --rot: 6deg;">🏅 ⭐</span>
        </div>
        <h1 class="login-title">Sistema Electoral Escolar Colombiano</h1>
        <nav class="login-menu" aria-label="Accesos principales">
            <a class="nav-btn <?php echo e(request()->routeIs('login.form') || request()->routeIs('voting.*') ? 'active' : ''); ?>" href="<?php echo e(route('login.form')); ?>">🗳️ Elecciones</a>
            <a class="nav-btn <?php echo e(request()->routeIs('admin.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.login.form')); ?>">⚙️ Administración</a>
            <a class="nav-btn <?php echo e(request()->routeIs('jury.*') ? 'active' : ''); ?>" href="<?php echo e(route('jury.login.form')); ?>">📋 Jurado</a>
        </nav>
        <div class="max-w-6xl mx-auto px-4 py-4">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </main>
<?php else: ?>
    <header class="app-header">
        <div class="max-w-6xl mx-auto px-4 py-3 flex flex-wrap items-center justify-between gap-3">
            <div class="flex items-center gap-3">
                <?php if($institutionLogo): ?>
                    <img src="<?php echo e($institutionLogo); ?>" alt="Logo <?php echo e($institutionName); ?>" class="h-12 w-12 rounded-full object-cover bg-white border-2 border-yellow-200">
                <?php else: ?>
                    <div class="app-logo">🏫</div>
                <?php endif; ?>
                <div>
                    <p class="app-title text-lg font-semibold leading-tight"><?php echo e($institutionName); ?></p>
                    <p class="text-sm text-slate-200 leading-tight">Proceso Electoral <?php echo e($institutionYear); ?></p>
                </div>
            </div>

            <div class="flex items-center gap-2 flex-wrap">
                <a class="nav-btn <?php echo e(request()->routeIs('login.form') || request()->routeIs('voting.*') ? 'active' : ''); ?>" href="<?php echo e(route('login.form')); ?>">Votantes</a>
                <a class="nav-btn <?php echo e(request()->routeIs('jury.*') ? 'active' : ''); ?>" href="<?php echo e(route('jury.login.form')); ?>">Jurados</a>
                <a class="nav-btn <?php echo e(request()->routeIs('admin.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.login.form')); ?>">Admin</a>
                <span class="status-pill text-yellow-100">Año <?php echo e($institutionYear); ?></span>
            </div>
        </div>
    </header>

    <div class="max-w-6xl mx-auto px-4 py-8">
        <?php echo $__env->yieldContent('content'); ?>
    </div>
<?php endif; ?>

<script>
    function makeSpiralDots(id, count) {
        const el = document.getElementById(id);
        if (!el) return;
        el.innerHTML = '';
        for (let i = 0; i < count; i++) {
            const d = document.createElement('div');
            d.className = 'nb-dot';
            el.appendChild(d);
        }
    }

    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('[data-spiral-count]').forEach(function (node) {
            const count = Number(node.getAttribute('data-spiral-count') || '10');
            if (!node.id) {
                node.id = 'sp-' + Math.random().toString(36).slice(2, 10);
            }
            makeSpiralDots(node.id, count);
        });
    });

    window.makeSpiralDots = makeSpiralDots;
</script>
</body>
</html>
<?php /**PATH C:\Users\Francisco\Documents\2026\APLICACIONES APPS\APPLICACIONES\SISVOT\resources\views\layouts\app.blade.php ENDPATH**/ ?>